const admin = require('firebase-admin');
const serviceAccount = require('../../../../firebase-service-account.json');

if (!admin.apps.length) {
  admin.initializeApp({
    credential: admin.credential.cert(serviceAccount),
  });
}

module.exports = {
  async afterCreate(event) {
    const { result } = event;

    if (result.is_notified === true) {
      await admin.messaging().send({
        topic: "all_users",
        notification: {
          title: result.Title,
          body: result.short_Description[0]?.children[0]?.text || '',
        },
      });
    }
  },
};
