const admin = require("firebase-admin");
const serviceAccount = require("../../../../firebase-service-account.json");

if (!admin.apps.length) {
  admin.initializeApp({
    credential: admin.credential.cert(serviceAccount),
  });
}

module.exports = {
  async sendNotification(title, body) {
    const message = {
      notification: {
        title: title,
        body: body,
      },
      topic: "allUsers",
    };

    await admin.messaging().send(message);
  },
};
