const admin = require("../../../utils/firebase");

module.exports = {
  async send(ctx) {
    const { title, body } = ctx.request.body;

    const tokens = await strapi.entityService.findMany(
      "api::device-token.device-token",
      { fields: ["token"] }
    );

    const message = {
      notification: { title, body },
      tokens: tokens.map(t => t.token),
    };

    const response = await admin.messaging().sendMulticast(message);

    ctx.send({
      success: true,
      sent: response.successCount,
    });
  },
};
